package coreservlets;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/** Serwlet, ktry zmienia nazw firmy. W pliku web.xml
 *  wskazano, e tylko uwierzytelnieni uytkownicy posiadajcy
 *  rol ceo mog wykonywa serwlet. Proces nasuchujcy atrybuty
 *  kontekstu serwletu uaktualnia poprzedni nazw firmy, gdy serwlet 
 *  (albo inny program) zmieni nazw biec.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ChangeCompanyName extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    boolean isNameChanged = false;
    String newName = request.getParameter("newName");
    if ((newName != null) && (!newName.equals(""))) {
      isNameChanged = true;
      getServletContext().setAttribute("companyName",
                                       newName);
    }
    response.setCharacterEncoding("UTF-8");        response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    String title = "Nazwa firmy";
    out.println
      (docType +
       "<HTML>\n" +
       "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
       "<BODY BGCOLOR=\"#FDF5E6\">\n" +
       "<H2 ALIGN=\"CENTER\">" + title + "</H2>");
    if (isNameChanged) {
      out.println("Nazwa firmy zostaa zmieniona na " + newName + ".");
    } else {
      out.println("Nazwa firmy nie ulega zmianie.");
    }
    out.println("</BODY></HTML>");
  }
}
